/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.terraforged.mod.featuremanager.FeatureManager;
import com.terraforged.mod.featuremanager.data.FolderDataPackFinder;
import com.terraforged.mod.featuremanager.data.ModDataPackFinder;
import com.terraforged.mod.featuremanager.data.ResourceVisitor;
import com.terraforged.mod.featuremanager.data.TagLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DataManager
implements AutoCloseable {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> NBT = s -> s.endsWith(".nbt");
    public static final Predicate<String> JSON = s -> s.endsWith(".json");
    private final ResourcePackList packList;
    private final IResourceManager resourceManager;

    public DataManager(IResourceManager resourceManager, ResourcePackList packList) {
        this.resourceManager = resourceManager;
        this.packList = packList;
    }

    @Override
    public void close() {
        this.packList.close();
    }

    public IResource getResource(ResourceLocation location) throws IOException {
        return this.resourceManager.func_199002_a(location);
    }

    public void forEach(String path, Predicate<String> matcher, ResourceVisitor<InputStream> consumer) {
        FeatureManager.LOG.debug("Input path: {}", (Object)path);
        for (ResourceLocation location : this.resourceManager.func_199003_a(path, matcher)) {
            FeatureManager.LOG.debug(" Location: {}", (Object)location);
            try {
                IResource resource = this.getResource(location);
                Throwable throwable = null;
                try {
                    if (resource == null) continue;
                    InputStream inputStream = resource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        consumer.accept(location, inputStream);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public <T extends IForgeRegistryEntry<T>> void forEachTag(String type, List<ITag.INamedTag<T>> tags, IForgeRegistry<T> registry, BiConsumer<ITag<T>, Set<T>> setter) {
        JsonParser parser = new JsonParser();
        String tagPath = "tags/" + type + "/";
        for (ITag.INamedTag<T> tag : tags) {
            try {
                HashSet set = new HashSet();
                ResourceLocation name = tag.func_230234_a_();
                String namespace = name.func_110624_b();
                String filepath = tagPath + name.func_110623_a() + ".json";
                ResourceLocation path = new ResourceLocation(namespace, filepath);
                for (IResource resource : this.resourceManager.func_199004_b(path)) {
                    InputStream inputStream = resource.func_199027_b();
                    Throwable throwable = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        JsonElement element = parser.parse((Reader)reader);
                        if (!element.isJsonObject()) continue;
                        TagLoader.loadTag(element.getAsJsonObject(), tag, registry, set);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                setter.accept((ITag<ITag.INamedTag<T>>)tag, set);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void forEachJson(String path, ResourceVisitor<JsonElement> consumer) {
        JsonParser parser = new JsonParser();
        this.forEach(path, JSON, (location, data) -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)data));
            JsonElement element = parser.parse((Reader)reader);
            consumer.accept(location, element);
        });
    }

    public static DataManager of(File dir) {
        SimpleReloadableResourceManager manager = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA);
        ResourcePackList packList = new ResourcePackList(ResourcePackInfo::new, new IPackFinder[0]);
        packList.addPackFinder((IPackFinder)new ModDataPackFinder());
        packList.addPackFinder((IPackFinder)new FolderDataPackFinder(dir));
        packList.func_198983_a();
        packList.func_198978_b().stream().map(ResourcePackInfo::func_195796_e).forEach(arg_0 -> ((SimpleReloadableResourceManager)manager).func_199021_a(arg_0));
        return new DataManager((IResourceManager)manager, packList);
    }
}

